//  binary.h -- convert base-10 to binary without imposing a runtime cost
// 
//  Copyright (C) 2001 Stephen Lacy (slacy@slacy.com)
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//  or find it on the web at http://www.gnu.org/copyleft/gpl.html

#define bin(x) ( \
     ((((x/10000000)%10)==1)?0x80:0x00) | \
     ((((x/1000000 )%10)==1)?0x40:0x00) | \
     ((((x/100000  )%10)==1)?0x20:0x00) | \
     ((((x/10000   )%10)==1)?0x10:0x00) | \
     ((((x/1000    )%10)==1)?0x08:0x00) | \
     ((((x/100     )%10)==1)?0x04:0x00) | \
     ((((x/10      )%10)==1)?0x02:0x00) | \
     ((((x/1       )%10)==1)?0x01:0x00))

